<?php

  // Copyright (c) 2012 Scott Alfter
  //
  // Permission is hereby granted, free of charge, to any person obtaining a
  // copy of this software and associated documentation files (the
  // "Software"), to deal in the Software without restriction, including
  // without limitation the rights to use, copy, modify, merge, publish,
  // distribute, sublicense, and/or sell copies of the Software, and to
  // permit persons to whom the Software is furnished to do so, subject to
  // the following conditions:
  //
  // The above copyright notice and this permission notice shall be included
  // in all copies or substantial portions of the Software.
  //
  // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
  // IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
  // CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
  // TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
  // SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  $baseurl="http://tmp.alfter.us/";
  $description="audio streams captured from KXNT";

  $doc = new DOMDocument("1.0", "UTF-8");
  $root = $doc->createElement("rss");
  $attr = $doc->createAttribute("version");

  $channel=$doc->createElement("channel");
  $channel->appendChild($doc->createElement("title","recordings"));
  $channel->appendChild($doc->createElement("link",$baseurl));
  $channel->appendChild($doc->createElement("description",$description));
  $latest=0;

  if ($h=opendir("."))
  {
    while (($e=readdir($h))!==false)
      if (strlen($e)>4)
        if (substr_compare($e,".m4a",-4,4)===0)
        {
          $item=$doc->createElement("item");
          $item->appendChild($doc->createElement("title",$e));
          $item->appendChild($doc->createElement("link",$baseurl.$e));
          $encl=$doc->createElement("enclosure");
          $enclURL=$doc->createAttribute("url");
          $enclURL->value=$baseurl.$e;
          $encl->appendChild($enclURL);
          $enclLength=$doc->createAttribute("length");
          $enclLength->value=filesize($e);
          $encl->appendChild($enclLength);
          $enclType=$doc->createAttribute("type");
          $enclType->value="audio/mp4a-latm";
          $encl->appendChild($enclType);
          $item->appendChild($encl);
          $item->appendChild($doc->createElement("pubDate",gmdate(DATE_RSS,date(filemtime($e)))));
          $channel->appendChild($item);
          if ($latest<filemtime($e))
            $latest=filemtime($e);
        }
    closedir($h);
  }

  $channel->appendChild($doc->createElement("lastBuildDate",gmdate(DATE_RSS,date($latest))));
  $root->appendChild($channel);
  $attr->value = "2.0";
  $root->appendChild($attr);
  $doc->appendChild($root);

  header("Content-Type: text/xml");
  echo $doc->SaveXML();
?>
